/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.mercury.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import xyz.gianlu.librespot.common.Base62;
import xyz.gianlu.librespot.common.Utils;
import xyz.gianlu.librespot.mercury.model.PlayableId;
import xyz.gianlu.librespot.mercury.model.SpotifyId;

public final class EpisodeId
implements SpotifyId,
PlayableId {
    static final Pattern PATTERN = Pattern.compile("spotify:episode:(.{22})");
    private static final Base62 BASE62 = Base62.createInstanceWithInvertedCharacterSet();
    private final String hexId;

    private EpisodeId(@NotNull String hex) {
        this.hexId = hex.toLowerCase();
    }

    @NotNull
    public static EpisodeId fromUri(@NotNull String uri) {
        Matcher matcher = PATTERN.matcher(uri);
        if (matcher.find()) {
            String id = matcher.group(1);
            return new EpisodeId(Utils.bytesToHex(BASE62.decode(id.getBytes(), 16)));
        }
        throw new IllegalArgumentException("Not a Spotify episode ID: " + uri);
    }

    @NotNull
    public static EpisodeId fromBase62(@NotNull String base62) {
        return new EpisodeId(Utils.bytesToHex(BASE62.decode(base62.getBytes(), 16)));
    }

    @NotNull
    public static EpisodeId fromHex(@NotNull String hex) {
        return new EpisodeId(hex);
    }

    @NotNull
    public String toMercuryUri() {
        return "hm://metadata/4/episode/" + this.hexId;
    }

    @Override
    @NotNull
    public String toSpotifyUri() {
        return "spotify:episode:" + new String(BASE62.encode(Utils.hexToBytes(this.hexId)));
    }

    @Override
    @NotNull
    public String hexId() {
        return this.hexId;
    }

    @Override
    @NotNull
    public byte[] getGid() {
        return Utils.hexToBytes(this.hexId);
    }

    @Override
    @NotNull
    public String toString() {
        return "EpisodeId{" + this.toSpotifyUri() + '}';
    }
}

