/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.util;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class SimpleTimerTask
implements Runnable {
    private volatile int state = 0;
    static final AtomicIntegerFieldUpdater<SimpleTimerTask> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(SimpleTimerTask.class, "state");
    static final int VIRGIN = 0;
    static final int SCHEDULED = 1;
    static final int EXECUTED = 2;
    static final int CANCELLED = 3;
    volatile long executionTime;

    protected SimpleTimerTask() {
    }

    @Override
    public abstract void run();

    public boolean cancel() {
        return stateUpdater.compareAndSet(this, 1, 3);
    }

    public boolean execute() {
        return stateUpdater.compareAndSet(this, 1, 2);
    }

    public boolean schedule() {
        return stateUpdater.compareAndSet(this, 0, 1);
    }

    public boolean isCancelled() {
        return this.state == 3;
    }

    public boolean isScheduled() {
        return this.state == 1;
    }

    public long scheduledExecutionTime() {
        return this.executionTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{state=" + this.state + ", executionTime=" + this.executionTime + '}';
    }
}

