/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.file.FormatDetector;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.toml.TomlParser;
import com.spotify.connectstate.Connect;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.gianlu.librespot.AbsConfiguration;
import xyz.gianlu.librespot.common.Utils;

public final class FileConfiguration
extends AbsConfiguration {
    private static final Logger LOGGER = Logger.getLogger(FileConfiguration.class);
    private final CommentedFileConfig config;

    public FileConfiguration(String ... override) throws IOException {
        boolean migrating;
        File oldConf;
        File confFile = null;
        if (override != null && override.length > 0) {
            for (String arg : override) {
                if (arg == null || !arg.startsWith("--conf-file=")) continue;
                confFile = new File(arg.substring(12));
            }
        }
        if (confFile == null) {
            confFile = new File("config.toml");
        }
        if (!confFile.exists() && (oldConf = new File("conf.properties")).exists()) {
            confFile = oldConf;
        }
        this.config = (CommentedFileConfig)CommentedFileConfig.builder((File)((migrating = FormatDetector.detect((File)confFile) instanceof PropertiesFormat) ? new File("config.toml") : confFile)).onFileNotFound(FileNotFoundAction.copyData((InputStream)FileConfiguration.streamDefaultConfig())).build();
        this.config.load();
        if (migrating) {
            FileConfiguration.migrateOldConfig(confFile, (FileConfig)this.config);
            this.config.save();
            confFile.delete();
            LOGGER.info((Object)"Your configuration has been migrated to `config.toml`, change your input file if needed.");
        } else {
            this.updateConfigFile((CommentedConfig)new TomlParser().parse(FileConfiguration.streamDefaultConfig()));
        }
        if (override != null && override.length > 0) {
            for (String str : override) {
                if (str == null || !str.contains("=") || !str.startsWith("--")) continue;
                String[] split = Utils.split((String)str, (char)'=');
                if (split.length != 2) {
                    LOGGER.warn((Object)("Invalid command line argument: " + str));
                    continue;
                }
                String key = split[0].substring(2);
                this.config.set(key, FileConfiguration.convertFromString(key, split[1]));
            }
        }
    }

    private static boolean removeDeprecatedKeys(@NotNull Config defaultConfig, @NotNull Config config, @NotNull FileConfig base, @NotNull String prefix) {
        boolean save = false;
        for (Config.Entry entry : new ArrayList(config.entrySet())) {
            String key = prefix + entry.getKey();
            if (entry.getValue() instanceof Config) {
                if (!FileConfiguration.removeDeprecatedKeys(defaultConfig, (Config)entry.getValue(), base, key + ".")) continue;
                save = true;
                continue;
            }
            if (defaultConfig.contains(key)) continue;
            LOGGER.trace((Object)("Removed entry from configuration file: " + key));
            base.remove(key);
            save = true;
        }
        return save;
    }

    private static boolean checkMissingKeys(@NotNull Config defaultConfig, @NotNull FileConfig config, @NotNull String prefix) {
        boolean save = false;
        for (Config.Entry entry : defaultConfig.entrySet()) {
            String key = prefix + entry.getKey();
            if (entry.getValue() instanceof Config) {
                if (!FileConfiguration.checkMissingKeys((Config)entry.getValue(), config, key + ".")) continue;
                save = true;
                continue;
            }
            if (config.contains(key)) continue;
            LOGGER.trace((Object)("Added new entry to configuration file: " + key));
            config.set(key, entry.getValue());
            save = true;
        }
        return save;
    }

    @NotNull
    private static Object convertFromString(@NotNull String key, @NotNull String value) {
        if (Objects.equals(key, "player.normalisationPregain")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Objects.equals(key, "deviceType")) {
            if (value.equals("AudioDongle")) {
                return "AUDIO_DONGLE";
            }
            return value.toUpperCase();
        }
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.parseBoolean(value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return value;
        }
    }

    private static void migrateOldConfig(@NotNull File confFile, @NotNull FileConfig config) throws IOException {
        Properties old = new Properties();
        try (FileReader fr = new FileReader(confFile);){
            old.load(fr);
        }
        for (Object key : old.keySet()) {
            String val = old.getProperty((String)key);
            config.set((String)key, FileConfiguration.convertFromString((String)key, val));
        }
    }

    @NotNull
    private static InputStream streamDefaultConfig() {
        InputStream defaultConfig = FileConfiguration.class.getClassLoader().getResourceAsStream("default.toml");
        if (defaultConfig == null) {
            throw new IllegalStateException();
        }
        return defaultConfig;
    }

    private void updateConfigFile(@NotNull CommentedConfig defaultConfig) {
        boolean save = FileConfiguration.checkMissingKeys((Config)defaultConfig, (FileConfig)this.config, "");
        if (FileConfiguration.removeDeprecatedKeys((Config)defaultConfig, (Config)this.config, (FileConfig)this.config, "")) {
            save = true;
        }
        if (save) {
            this.config.clearComments();
            for (Map.Entry entry : defaultConfig.getComments().entrySet()) {
                UnmodifiableCommentedConfig.CommentNode node = (UnmodifiableCommentedConfig.CommentNode)entry.getValue();
                if (!this.config.contains((String)entry.getKey())) continue;
                this.config.setComment((String)entry.getKey(), node.getComment());
                Map children = node.getChildren();
                if (children == null) continue;
                ((CommentedConfig)this.config.getRaw((String)entry.getKey())).putAllComments(children);
            }
            this.config.save();
        }
    }

    @Override
    @Nullable
    public String deviceId() {
        return "c70f928698cc099e39bddfd469f7de38e3b805db";
    }

    @Override
    @Nullable
    public String deviceName() {
        return "sp-playcount-librespot";
    }

    @Override
    @Nullable
    public Connect.DeviceType deviceType() {
        return Connect.DeviceType.UNKNOWN;
    }

    @Override
    @NotNull
    public String preferredLocale() {
        return (String)this.config.get("preferredLocale");
    }

    @Override
    @NotNull
    public Level loggingLevel() {
        String str = (String)this.config.get("logLevel");
        return Level.toLevel((String)str);
    }

    @Override
    public boolean storeCredentials() {
        return (Boolean)this.config.get("storeCredentials");
    }

    @Override
    @Nullable
    public File credentialsFile() {
        String path = (String)this.config.get("credentialsFile");
        if (path == null || path.isEmpty()) {
            return null;
        }
        return new File(path);
    }

    @Override
    public int port() {
        return (Integer)this.config.get("server.port");
    }

    @Override
    @NotNull
    public String albumEndpoint() {
        return (String)this.config.get("server.albumEndpoint");
    }

    @Override
    @NotNull
    public String artistEndpoint() {
        return (String)this.config.get("server.artistEndpoint");
    }

    @Override
    @NotNull
    public String artistAboutEndpoint() {
        return (String)this.config.get("server.artistAboutEndpoint");
    }

    @Override
    @NotNull
    public String artistInsightsEndpoint() {
        return (String)this.config.get("server.artistInsightsEndpoint");
    }

    @Override
    public boolean enableHttps() {
        return (Boolean)this.config.get("server.enableHttps");
    }

    @Override
    @Nullable
    public String httpsKs() {
        return (String)this.config.get("server.httpsKs");
    }

    @Override
    @Nullable
    public String httpsKsPass() {
        return (String)this.config.get("server.httpsKsPass");
    }

    static {
        FormatDetector.registerExtension((String)"properties", (ConfigFormat)new PropertiesFormat());
    }

    private static final class PropertiesFormat
    implements ConfigFormat<Config> {
        private PropertiesFormat() {
        }

        public ConfigWriter createWriter() {
            return null;
        }

        public ConfigParser<Config> createParser() {
            return null;
        }

        public Config createConfig(Supplier<Map<String, Object>> mapCreator) {
            return null;
        }

        public boolean supportsComments() {
            return false;
        }
    }
}

