/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.common;

import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NotNull;

public final class NameThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final NameProvider nameProvider;

    public NameThreadFactory(@NotNull NameProvider nameProvider) {
        this.nameProvider = nameProvider;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(@NotNull Runnable r) {
        Thread t = new Thread(this.group, r, this.nameProvider.getName(r), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public static interface NameProvider {
        @NotNull
        public String getName(@NotNull Runnable var1);
    }
}

