/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.handler;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cache2k.Cache;
import xyz.gianlu.librespot.UrlParse;
import xyz.gianlu.librespot.mercury.MercuryClient;
import xyz.gianlu.librespot.mercury.MercuryRequests;

public class ArtistInfoHandler
implements HttpHandler {
    private MercuryClient mercuryClient;
    private UrlParse urlParse;
    private Cache<String, String> cache;

    public ArtistInfoHandler(MercuryClient mc, Cache<String, String> cache) {
        this.mercuryClient = mc;
        this.urlParse = new UrlParse();
        this.cache = cache;
    }

    @Override
    public void handle(HttpExchange httpEx) throws IOException {
        String response;
        int statusCode;
        if (httpEx.getRequestMethod().equals("GET")) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            if (httpEx.getRequestURI().getQuery() == null) {
                statusCode = 400;
                res.put("success", false);
                res.put("data", "artistid is not defined in the query");
                response = String.format("{\"success\": %s, \"data\": \"%s\"}", res.get("success"), res.get("data"));
            } else {
                Map<String, List<String>> query = this.urlParse.parse(httpEx.getRequestURI().getQuery());
                if (!query.containsKey("artistid")) {
                    statusCode = 400;
                    res.put("success", false);
                    res.put("data", "artistid is not defined in the query");
                    response = String.format("{\"success\": %s, \"data\": \"%s\"}", res.get("success"), res.get("data"));
                } else if (query.get("artistid").get(0).length() != 22) {
                    statusCode = 400;
                    res.put("success", false);
                    res.put("data", "artistid is invalid; artistid length does not equal 22");
                    response = String.format("{\"success\": %s, \"data\": \"%s\"}", res.get("success"), res.get("data"));
                } else {
                    String artistId = query.get("artistid").get(0);
                    if (this.cache.containsKey("artist:" + artistId)) {
                        statusCode = 200;
                        response = this.cache.get("artist:" + artistId);
                    } else {
                        try {
                            MercuryRequests.GenericJsonWrapper respInfo = this.mercuryClient.sendSync(MercuryRequests.getArtistInfo(artistId));
                            statusCode = 200;
                            res.put("success", true);
                            res.put("dataInfo", respInfo.obj);
                            MercuryRequests.GenericJsonWrapper respAbout = this.mercuryClient.sendSync(MercuryRequests.getArtistAbout(artistId));
                            res.put("dataAbout", respAbout.obj);
                            MercuryRequests.GenericJsonWrapper respInsights = this.mercuryClient.sendSync(MercuryRequests.getArtistInsights(artistId));
                            res.put("dataInsights", respInsights.obj);
                            response = String.format("{\"success\": %s, \"dataInfo\": %s, \"dataAbout\": %s, \"dataInsights\": %s", res.get("success"), res.get("dataInfo"), res.get("dataAbout"), res.get("dataInsights"));
                            String[] split = response.split("\"uri\":\"spotify:album:");
                            System.out.println("length: " + split.length);
                            for (int i = 17; i <= split.length - 1; ++i) {
                                String albumId = split[i].substring(0, 22);
                                try {
                                    MercuryRequests.GenericJsonWrapper resp = this.mercuryClient.sendSync(MercuryRequests.getAlbumInfo(albumId));
                                    res.put("success", true);
                                    res.put("data", resp.obj);
                                    response = response + String.format(", \"data\": %s", res.get("data"));
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                response = response + String.format("}", new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            res.put("success", false);
                            if (e.getMessage().startsWith("status: ")) {
                                statusCode = Integer.parseInt(e.getMessage().substring(8));
                                if (statusCode == 404) {
                                    res.put("data", "artistid invalid; couldn't find artist");
                                } else {
                                    e.printStackTrace();
                                    res.put("data", "An unknown error has occurred; logged to console");
                                }
                            } else {
                                statusCode = 500;
                                e.printStackTrace();
                                res.put("data", "An unknown error has occurred; logged to console");
                            }
                            response = String.format("{\"success\": %s, \"data\": \"%s\"}", res.get("success"), res.get("data"));
                        }
                        if (statusCode == 200) {
                            this.cache.putIfAbsent("artist:" + artistId, response);
                        }
                    }
                }
            }
        } else {
            statusCode = 404;
            response = "Cannot " + httpEx.getRequestMethod() + " " + httpEx.getRequestURI().toString();
        }
        httpEx.getResponseHeaders().set("Content-Type", "application/json; charset=utf-8");
        httpEx.sendResponseHeaders(statusCode, response.getBytes().length);
        OutputStream os = httpEx.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }
}

