/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.common;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public final class Base62 {
    private static final int STANDARD_BASE = 256;
    private static final int TARGET_BASE = 62;
    private final byte[] alphabet;
    private byte[] lookup;

    private Base62(byte[] alphabet) {
        this.alphabet = alphabet;
        this.createLookupTable();
    }

    public static Base62 createInstance() {
        return Base62.createInstanceWithGmpCharacterSet();
    }

    public static Base62 createInstanceWithGmpCharacterSet() {
        return new Base62(CharacterSets.GMP);
    }

    public static Base62 createInstanceWithInvertedCharacterSet() {
        return new Base62(CharacterSets.INVERTED);
    }

    public byte[] encode(byte[] message, int length) {
        byte[] indices = this.convert(message, 256, 62, length);
        return this.translate(indices, this.alphabet);
    }

    public byte[] encode(byte[] message) {
        return this.encode(message, -1);
    }

    public byte[] decode(byte[] encoded, int length) {
        byte[] prepared = this.translate(encoded, this.lookup);
        return this.convert(prepared, 62, 256, length);
    }

    public byte[] decode(byte[] encoded) {
        return this.decode(encoded, -1);
    }

    private byte[] translate(byte[] indices, byte[] dictionary) {
        byte[] translation = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return translation;
    }

    private byte[] convert(byte[] message, int sourceBase, int targetBase, int length) {
        int estimatedLength = length == -1 ? this.estimateOutputLength(message.length, sourceBase, targetBase) : length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = message;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte b : source) {
                int accumulator = (b & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        if (out.size() < estimatedLength) {
            int size = out.size();
            for (int i = 0; i < estimatedLength - size; ++i) {
                out.write(0);
            }
            return this.reverse(out.toByteArray());
        }
        if (out.size() > estimatedLength) {
            return this.reverse(Arrays.copyOfRange(out.toByteArray(), 0, estimatedLength));
        }
        return this.reverse(out.toByteArray());
    }

    private int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
    }

    private byte[] reverse(byte[] arr) {
        int length = arr.length;
        byte[] reversed = new byte[length];
        for (int i = 0; i < length; ++i) {
            reversed[length - i - 1] = arr[i];
        }
        return reversed;
    }

    private void createLookupTable() {
        this.lookup = new byte[256];
        for (int i = 0; i < this.alphabet.length; ++i) {
            this.lookup[this.alphabet[i]] = (byte)(i & 0xFF);
        }
    }

    private static class CharacterSets {
        private static final byte[] GMP = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        private static final byte[] INVERTED = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

        private CharacterSets() {
        }
    }
}

