/*
 * Decompiled with CFR 0.152.
 */
package xyz.gianlu.librespot.mercury.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public interface SpotifyId {
    public static final String STATIC_FROM_URI = "fromUri";
    public static final String STATIC_FROM_BASE62 = "fromBase62";
    public static final String STATIC_FROM_HEX = "fromHex";

    @NotNull
    public static <I extends SpotifyId> I fromBase62(Class<I> clazz, String base62) throws SpotifyIdParsingException {
        return SpotifyId.callReflection(clazz, STATIC_FROM_BASE62, base62);
    }

    @NotNull
    public static <I extends SpotifyId> I fromHex(Class<I> clazz, String hex) throws SpotifyIdParsingException {
        return SpotifyId.callReflection(clazz, STATIC_FROM_HEX, hex);
    }

    @NotNull
    public static <I extends SpotifyId> I fromUri(Class<I> clazz, String uri) throws SpotifyIdParsingException {
        return SpotifyId.callReflection(clazz, STATIC_FROM_URI, uri);
    }

    @NotNull
    public static <I extends SpotifyId> I callReflection(@NotNull Class<I> clazz, @NotNull String name, @NotNull String arg) throws SpotifyIdParsingException {
        try {
            Method method = clazz.getDeclaredMethod(name, String.class);
            return (I)((SpotifyId)method.invoke(null, arg));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SpotifyIdParsingException(ex);
        }
    }

    @NotNull
    public String toSpotifyUri();

    public static class SpotifyIdParsingException
    extends Exception {
        SpotifyIdParsingException(Throwable cause) {
            super(cause);
        }
    }
}

